package fr.asip.cps3.exemple.vues.menus;

import java.awt.event.ActionListener;
import fr.asip.cps3.exemple.modele.objets.Algo;

/**
 * Classe modlisant un item de menu de type Algorithme
 *
 */
public class ItemMenuAlgo extends ItemMenu {
	
	private static final long serialVersionUID = 3729974411401157688L;
	
	/**
	 * Algorithme associ  l'item de menu
	 */
	private Algo algo;

	/**
	 * Constructeur  5 arguments
	 * @param algo Algorithme associ  l'item de menu
	 * @param idParent Identifiant du menu parent
	 * @param enable Boolen attestant du caractre actionnable de l'item de menu
	 * @param visible Boolen attestant du caractre visible de l'item de menu
	 * @param ecouteur Ecouteur positionn sur l'item de menu
	 */
	public ItemMenuAlgo(Algo algo,String idParent, boolean enable, boolean visible, ActionListener ecouteur) {
		
		super(idParent+",", idParent, "", enable, visible, ecouteur);
		this.algo = algo;
		if(algo != null) {
			setId(getIdParent()+","+algo.getIdAlgo());
			setText(algo.getLibelle());
		}
		
	}

	/**
	 * Accesseur
	 * @return Algorithme associ  l'item de menu
	 */
	public Algo getAlgo() {
		return algo;
	}


	
}
